<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>All State Ration to Aadhar - History</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
</head>
<body>

<?php
include('../header.php');

$username = $udata['phone'];

// Create history table if not exists
@mysqli_query($ahk_conn, "CREATE TABLE IF NOT EXISTS all_state_ration_to_aadhar_history (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(100) NOT NULL,
    ration_number VARCHAR(100) NOT NULL,
    api_response TEXT,
    members_count INT(11) DEFAULT 0,
    service_charge DECIMAL(10,2) DEFAULT 0,
    status VARCHAR(50) DEFAULT 'Success',
    date DATETIME DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_username (username),
    INDEX idx_ration (ration_number),
    INDEX idx_date (date)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

// Fetch history
$history_query = mysqli_query($ahk_conn, "SELECT * FROM all_state_ration_to_aadhar_history WHERE username='$username' ORDER BY id DESC");
?>

<div class="page-wrapper">
<div class="page-content">
<div class="card">
<div class="card-body">

<div class="d-flex justify-content-between align-items-center mb-3">
    <h4><i class="fas fa-history me-2"></i>All State Ration to Aadhar - History</h4>
    <a href="all-state-ration-to-aadhar.php" class="btn btn-primary">
        <i class="fas fa-plus me-1"></i>New Search
    </a>
</div>

<div class="table-responsive">
    <table id="historyTable" class="table table-striped table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Ration Number</th>
                <th>Members</th>
                <th>Service Charge</th>
                <th>Status</th>
                <th>Date</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if ($history_query && mysqli_num_rows($history_query) > 0) {
                while($row = mysqli_fetch_assoc($history_query)) {
                    // Decode the JSON response
                    $api_response = json_decode($row['api_response'], true);
                    
                    // Check if data exists in the response (new format)
                    $family_members = [];
                    if (isset($api_response['data']['members']) && is_array($api_response['data']['members'])) {
                        $family_members = $api_response['data']['members'];
                    } elseif (isset($api_response['members']) && is_array($api_response['members'])) {
                        $family_members = $api_response['members'];
                    }
                    
                    // Get status from API response if available
                    $display_status = $row['status'];
                    if (isset($api_response['status'])) {
                        $display_status = $api_response['status'];
                    } elseif (isset($api_response['data']['status'])) {
                        $display_status = $api_response['data']['status'];
                    }
                    ?>
                    <tr>
                        <td><?php echo $row['id']; ?></td>
                        <td><strong><?php echo htmlspecialchars($row['ration_number']); ?></strong></td>
                        <td><?php echo $row['members_count']; ?> members</td>
                        <td>₹<?php echo number_format($row['service_charge'], 2); ?></td>
                        <td>
                            <?php if($display_status == 'success' || $row['status'] == 'Success'): ?>
                                <span class="badge bg-success">Success</span>
                            <?php else: ?>
                                <span class="badge bg-danger"><?php echo htmlspecialchars($display_status); ?></span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo date('d/m/Y h:i A', strtotime($row['date'])); ?></td>
                        <td>
                            <?php if(!empty($family_members)): ?>
                                <?php 
                                // Encode row data as JSON then base64 for safe HTML attribute storage
                                $row_json = json_encode($row, JSON_UNESCAPED_UNICODE);
                                $row_encoded = base64_encode($row_json);
                                ?>
                                <button class="btn btn-sm btn-info view-details-btn" data-row-data="<?php echo htmlspecialchars($row_encoded, ENT_QUOTES, 'UTF-8'); ?>">
                                    <i class="fas fa-eye"></i> View Details
                                </button>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php
                }
            } else {
                ?>
                <tr>
                    <td colspan="7" class="text-center py-4">
                        <i class="fas fa-inbox fa-2x text-muted mb-2"></i><br>
                        <p class="text-muted">No search history found</p>
                        <a href="all-state-ration-to-aadhar.php" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i>Start New Search
                        </a>
                    </td>
                </tr>
                <?php
            }
            ?>
        </tbody>
    </table>
</div>

</div>
</div>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>

<script>
$(document).ready(function() {
    $('#historyTable').DataTable({
        order: [[0, 'desc']],
        pageLength: 25,
        responsive: true
    });
    
    // Handle View Details button clicks using event delegation
    $(document).on('click', '.view-details-btn', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        var $btn = $(this);
        var rowDataBase64 = $btn.attr('data-row-data');
        
        if (!rowDataBase64) {
            console.error('No row data found');
            alert('No data available');
            return;
        }
        
        try {
            // Decode from base64, then parse JSON
            var rowDataJson = atob(rowDataBase64);
            var rowData = JSON.parse(rowDataJson);
            console.log('Successfully decoded and parsed row data:', rowData);
            viewDetails(rowData);
        } catch(error) {
            console.error('Decode/Parse Error:', error);
            console.error('Base64 data:', rowDataBase64);
            
            Swal.fire({
                title: 'Error',
                html: 'Failed to load data: ' + error.message + '<br><small>Please try refreshing the page.</small>',
                icon: 'error',
                footer: '<small>Check browser console (F12) for details</small>'
            });
        }
    });
});

// Make viewDetails available globally
window.viewDetails = function(row) {
    console.log('viewDetails called - Initial data:', typeof row, row);
    
    // Check if SweetAlert2 is loaded
    if (typeof Swal === 'undefined') {
        alert('SweetAlert2 not loaded. Please refresh the page.');
        console.error('SweetAlert2 not available');
        return;
    }
    
    try {
        // Handle if row is already an object or needs parsing
        var rowData = row;
        if (typeof row === 'string') {
            try {
                rowData = JSON.parse(row);
            } catch(e) {
                console.error('Failed to parse row string:', e);
                Swal.fire({
                    title: 'Error',
                    text: 'Invalid data format: ' + e.message,
                    icon: 'error'
                });
                return;
            }
        }
        
        if (!rowData) {
            Swal.fire({
                title: 'Error',
                text: 'No data available',
                icon: 'error'
            });
            return;
        }
        
        console.log('RowData after parsing:', rowData);
        console.log('api_response type:', typeof rowData.api_response);
        console.log('api_response preview:', rowData.api_response ? rowData.api_response.substring(0, 200) : 'NULL');
        
        // Parse api_response - it's stored as JSON string in database
        var apiResponse = {};
        if (rowData.api_response) {
            try {
                if (typeof rowData.api_response === 'string') {
                    apiResponse = JSON.parse(rowData.api_response);
                } else if (typeof rowData.api_response === 'object') {
                    apiResponse = rowData.api_response;
                }
            } catch(e) {
                console.error('Failed to parse api_response:', e);
                Swal.fire({
                    title: 'Parse Error',
                    text: 'Failed to parse API response: ' + e.message,
                    icon: 'error',
                    footer: '<small>api_response type: ' + typeof rowData.api_response + '</small>'
                });
                return;
            }
        }
        
        console.log('API Response parsed:', apiResponse);
        
        // Extract family members from multiple possible locations
        var familyMembers = [];
        if (apiResponse.data && apiResponse.data.members && Array.isArray(apiResponse.data.members)) {
            familyMembers = apiResponse.data.members;
        } else if (apiResponse.members && Array.isArray(apiResponse.members)) {
            familyMembers = apiResponse.members;
        } else if (apiResponse.raw_response && apiResponse.raw_response.data && apiResponse.raw_response.data.members) {
            familyMembers = apiResponse.raw_response.data.members;
        } else if (apiResponse.raw_response && apiResponse.raw_response.members) {
            familyMembers = apiResponse.raw_response.members;
        }
        
        // Get all member fields dynamically
        var memberFields = [];
        if (familyMembers.length > 0) {
            // Get all unique keys from all members
            familyMembers.forEach(function(member) {
                Object.keys(member).forEach(function(key) {
                    if (memberFields.indexOf(key) === -1) {
                        memberFields.push(key);
                    }
                });
            });
        }
        
        var detailsHtml = "<div style='text-align:left; max-height:600px; overflow-y:auto; font-family: Arial, sans-serif;'>";
        detailsHtml += "<div style='background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 15px; border-radius: 10px; margin-bottom: 15px;'>";
        detailsHtml += "<h5 style='margin: 0 0 10px 0;'><i class='fas fa-info-circle'></i> Search Information</h5>";
        detailsHtml += "<b>Ration Number:</b> " + (rowData.ration_number || 'N/A') + "<br>";
        detailsHtml += "<b>Members Found:</b> " + (rowData.members_count || familyMembers.length) + "<br>";
        detailsHtml += "<b>Service Charge:</b> ₹" + parseFloat(rowData.service_charge || 0).toFixed(2) + "<br>";
        detailsHtml += "<b>Date:</b> " + (rowData.date || 'N/A') + "<br>";
        
        // Show API status if available
        var apiStatus = apiResponse.status || (apiResponse.data && apiResponse.data.status) || 'N/A';
        var apiMessage = apiResponse.message || (apiResponse.data && apiResponse.data.message) || '';
        
        if (apiStatus && apiStatus !== 'N/A') {
            detailsHtml += "<b>API Status:</b> <span style='background: rgba(255,255,255,0.3); padding: 2px 8px; border-radius: 4px;'>" + apiStatus + "</span><br>";
        }
        if (apiMessage) {
            detailsHtml += "<b>Message:</b> " + apiMessage + "<br>";
        }
        
        detailsHtml += "</div>";
        
        // Show Family Members with ALL fields
        if (familyMembers.length > 0) {
            detailsHtml += "<div style='margin-top: 15px;'>";
            detailsHtml += "<h6 style='color: #333; margin-bottom: 10px;'><i class='fas fa-users'></i> Family Members Details (" + familyMembers.length + "):</h6>";
            detailsHtml += "<div style='overflow-x: auto;'>";
            detailsHtml += "<table border='1' cellpadding='8' cellspacing='0' style='width:100%; border-collapse:collapse; font-size:12px; background: white;'>";
            detailsHtml += "<tr style='background:#667eea; color: white;'>";
            detailsHtml += "<th style='padding: 8px; text-align: center;'>Sr</th>";
            
            // Add all fields as columns
            var displayFields = memberFields.length > 0 ? memberFields : ['name', 'aadhaar'];
            displayFields.forEach(function(field) {
                var fieldLabel = field.charAt(0).toUpperCase() + field.slice(1).replace(/_/g, ' ');
                detailsHtml += "<th style='padding: 8px; text-align: left;'>" + fieldLabel + "</th>";
            });
            
            detailsHtml += "</tr>";
            
            familyMembers.forEach(function(member, index) {
                detailsHtml += "<tr" + (index % 2 === 0 ? " style='background:#f8f9fa;'" : "") + ">";
                detailsHtml += "<td style='padding: 8px; text-align: center; font-weight: bold;'>" + (index + 1) + "</td>";
                
                displayFields.forEach(function(field) {
                    var value = member[field] || 'N/A';
                    if (field.toLowerCase() === 'aadhaar' || field.toLowerCase().includes('aadhar')) {
                        value = "<strong style='color: #28a745;'>" + value + "</strong>";
                    }
                    detailsHtml += "<td style='padding: 8px;'>" + value + "</td>";
                });
                
                detailsHtml += "</tr>";
            });
            
            detailsHtml += "</table>";
            detailsHtml += "</div>";
            detailsHtml += "</div>";
        } else {
            detailsHtml += "<div style='background: #fff3cd; padding: 15px; border-radius: 5px; border-left: 4px solid #ffc107; margin-top: 15px;'>";
            detailsHtml += "<p style='margin: 0; color: #856404;'><i class='fas fa-exclamation-triangle'></i> No family member data available</p>";
            if (apiResponse.message || (apiResponse.data && apiResponse.data.message)) {
                detailsHtml += "<p style='margin: 5px 0 0 0; color: #856404;'>" + (apiResponse.message || apiResponse.data.message) + "</p>";
            }
            detailsHtml += "</div>";
        }
        
        detailsHtml += "</div>";
        
        Swal.fire({
            title: '<span style="color: #667eea;"><i class="fas fa-search"></i> All State Ration to Aadhar - Complete Details</span>',
            html: detailsHtml,
            width: 1100,
            confirmButtonText: 'Close',
            showCloseButton: true,
            customClass: {
                popup: 'swal-wide'
            }
        });
    } catch (error) {
        var errorData = 'No data';
        try {
            if (rowData && rowData.api_response) {
                var apiRespStr = typeof rowData.api_response === 'string' ? rowData.api_response : JSON.stringify(rowData.api_response);
                errorData = apiRespStr.substring(0, 100) + '...';
            }
        } catch(e) {
            errorData = 'Unable to extract data';
        }
        
        Swal.fire({
            title: 'Error',
            text: 'Unable to parse data: ' + error.message,
            icon: 'error',
            footer: '<small>Raw data: ' + errorData + '</small>'
        });
        console.error('viewDetails Error:', error);
        console.error('Row data:', rowData);
    }
};
</script>

<?php include('../footer.php'); ?>
</body>
</html>

